<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwtrait="urn:WebWorks-Engine-FormatTraitInfo-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwfiles wwsplits wwdoc wwproject wwtrait wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterType" />


 <xsl:namespace-alias stylesheet-prefix="wwlinks" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwlinks-paragraphs-by-topic" match="wwlinks:Paragraph" use="@topic" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

   <xsl:for-each select="$VarFilesByType[1]">
    <xsl:variable name="VarFilesEntry" select="." />

    <wwfiles:Files version="1.0">
     <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwprojext:GetTargetDataDirectoryPath(), concat(translate($ParameterType, ':', '_'),'.xml'))" />

     <!-- Up to date? -->
     <!--             -->
     <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, wwprojext:GetDocumentsToGenerateChecksum(), '', '', $GlobalActionChecksum)" />
     <xsl:if test="not($VarUpToDate)">
      <xsl:variable name="VarResultAsXML">
       <xsl:variable name="VarLinks" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesEntry/@path)" />

       <wwlinks:Links version="1.0">
        <xsl:for-each select="$VarLinks/wwlinks:Links/wwlinks:File">
         <xsl:variable name="VarLinksFile" select="." />

         <xsl:copy>
          <xsl:copy-of select="@*" />

          <xsl:for-each select="wwlinks:Paragraph">
           <xsl:variable name="VarLinksParagraph" select="." />

           <wwlinks:Paragraph>
            <!-- Duplicate existing attributes -->
            <!--                               -->
            <xsl:copy-of select="@*[local-name() != 'topic']" />

            <!-- Emit last unique topic -->
            <!--                        -->
            <xsl:if test="string-length($VarLinksParagraph/@topic) &gt; 0">
             <xsl:variable name="VarLinksParagraphsWithTopic" select="key('wwlinks-paragraphs-by-topic', $VarLinksParagraph/@topic)" />
             <xsl:variable name="VarLinksGroupParagraphsWithTopic" select="$VarLinksParagraphsWithTopic[../@groupID = $VarLinksFile/@groupID]" />

             <xsl:if test="count($VarLinksParagraph | $VarLinksGroupParagraphsWithTopic[count($VarLinksGroupParagraphsWithTopic)]) = 1">
              <xsl:attribute name="topic">
               <xsl:value-of select="$VarLinksParagraph/@topic" />
              </xsl:attribute>
             </xsl:if>
            </xsl:if>

            <!-- Tag first page link -->
            <!--                     -->
            <xsl:attribute name="first">
             <xsl:value-of select="position() = 1" />
            </xsl:attribute>
           </wwlinks:Paragraph>
          </xsl:for-each>
         </xsl:copy>
        </xsl:for-each>
       </wwlinks:Links>
      </xsl:variable>
      <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
      <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, 'utf-8', 'xml', '1.0', 'yes')" />
     </xsl:if>

     <!-- Single links file for the whole project -->
     <!--                                         -->
     <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{wwprojext:GetDocumentsToGenerateChecksum()}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}">
      <wwfiles:Depends path="{$VarFilesEntry/@path}" checksum="{$VarFilesEntry/@checksum}" groupID="{$VarFilesEntry/@groupID}" documentID="{$VarFilesEntry/@documentID}" />
     </wwfiles:File>
    </wwfiles:Files>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
